;In 48k, we use the Orfeus Music player, initiating it before entering the menu loop. The
;original Orfeus player has been tweaked for I Need Speed, removing the memory swapping
;reubication routine, changing the initialization sequence, and changing the interrupt
;handling routine to be able to execute the menu code while the music is still playing.

		org 	$8902

orfeus_start:	ld 	hl,($8cf3)	 ; 8902		Init some variables to start the song correctly
		ld 	($8c0d),hl	 ; 8905
		ld 	hl,($8cf5)	 ; 8908
		ld 	($8c24),hl	 ; 890b
		ld 	hl,($8cf7)	 ; 890e
		ld 	($8c3b),hl 	 ; 8911

		di			 ; 893c		Disable interrupts
		ld 	(stackback+1),sp ; 893d 	Return stack pointer
		
		ld 	sp,stackorfeus_limit-2	 	; 8941 New Orfeus stack pointer, in mapa_checks buffer
		ld 	hl, $89f3	 ; 8944
		ld 	(interrupt_redir+1),hl; 8947	;Set interrupts to Orfeus routine
		xor 	a		 ; 8914
		INCBIN	"bindata/orf1.bin"	;Orfeus code with constants adapted to the song, from $894f to $8c50

orfeustimer: 	ld a,0			 ; 8c51		Get counter
		and a			 ; 8c54
		jr z,orf_trykey		 ; 8c55		If it's zero, try if a key is pressed
		dec a			 ; 8c57		If it's not zero, decrease counter
		ld (orfeustimer+1),a	 ; 8c58		Update it
		ret nz			 ; 8c5b		Return if not 0 (keep playing)
		jr l_8c64		 ; 8c5c
orf_trykey:	in a, ($fe)		 ; 8c5e
		cpl			 ; 8c60
		and $1f			 ; 8c61
		ret z			 ; 8c63		Return if no key is pressed
l_8c64:		push af			 ; 8c64		Exit Orfeus: push all used registers into stack
		push hl			 ; 8c65
		push de			 ; 8c66
		push bc			 ; 8c67
		exx			 ; 8c68
		push bc			 ; 8c69
		ld (stackback2+1),sp 	 ; 8c6a 	Keep Orfeus stack pointer
stackback:	ld sp,0000		 ; 8c6e		Restore return stack pointer
		ld hl,int_end	 	 ; 8c71
		ld (interrupt_redir+1),hl; 8c74		Disable orfeus on interrupt
l_8c75:		ei			 ; 8c77		Enable interrupts
		ret			 ; 8c78
		nop

		INCBIN	"bindata/orf2.bin"	;Some more Orfeus code and tables, then the song, from 8c79 till end
